<?php

namespace App\Exports;

use App\Models\Transaksi;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;

class PenjualanExport implements FromView
{
    protected $petugas;
    protected $penjualan;
    protected $via;
    protected $tgl1;
    protected $tgl2;

    function __construct($petugas, $penjualan, $via, $tgl1, $tgl2)
    {
        $this->petugas = $petugas;
        $this->penjualan = $penjualan;
        $this->via = $via;
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
    }

    public function  view(): View
    {
        if ($this->penjualan == 1) {
            if ($this->via == 1) {
                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => 'PEMBAYARAN CASH',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id',   $this->petugas)
                        ->get();
                }
            } else  if ($this->via == 2) {
                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => 'PEMBAYARAN TRANSFER',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id',   $this->petugas)
                        ->get();
                }
            } else if ($this->via == 3) {
                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => '',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id',   $this->petugas)
                        ->get();
                }
            } else {
                echo 'Data tidak ditemukan';
            }
        } else  if ($this->penjualan == 2) {
            $data = [
                'jns' => 'TRANSAKSI ONLINE',
                'via' => '',
                'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
            ];
            if ($this->petugas == 'All') {
                $transaksi = Transaksi::where('jns_transaksi', 'ON')
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                    ->where('sts_transaksi', 'N')
                    ->get();
            } else {
                $transaksi = Transaksi::where('jns_transaksi', 'ON')
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                    ->where('sts_transaksi', 'N')
                    ->where('user_id',   $this->petugas)
                    ->get();
            }
        } else if ($this->penjualan == 3) {
            if ($this->via == 1) {
                $data = [
                    'jns' => '',
                    'via' => 'PEMBAYARAN CASH',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id',   $this->petugas)
                        ->get();
                }
            } else  if ($this->via == 2) {
                $data = [
                    'jns' => '',
                    'via' => 'PEMBAYARAN TRANSFER',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('user_id',   $this->petugas)
                        ->where('sts_transaksi', 'N')
                        ->get();
                }
            } else if ($this->via == 3) {


                $data = [
                    'jns' => '',
                    'via' => '',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
                ];
                if ($this->petugas == 'All') {
                    $transaksi = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=',  $this->tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=',  $this->tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id',   $this->petugas)
                        ->get();
                }
            } else {
                echo 'Data tidak ditemukan';
            }
        } else {
            echo 'Data tidak ditemukan';
        }
        return view('admin.laporan.export_penjualan', [
            'transaksi' => $transaksi,
            'no' => 1,
            'data' =>  $data,
        ]);
    }
}
